from django.db import models

# Create your models here.
class TransactionRequest(models.Model):
    STATUS_CHOICES = [
        ("pending", "Pending"),
        ("approved", "Approved"),
        ("rejected", "Rejected"),
    ]

    user_id = models.CharField(max_length=100)  # from Flutter app
    amount = models.DecimalField(max_digits=10, decimal_places=2)
    status = models.CharField(max_length=20, choices=STATUS_CHOICES, default="pending")
    txn_type = models.CharField(max_length=50, choices=[('widthdrawal',"Withdrawal"), ("deposit", "Deposit")])  # e.g., "withdrawal", "deposit"
    txn_id = models.CharField(max_length=100, blank=True, null=True)  # Transaction ID from the payment gateway
    utr = models.CharField(max_length=100, blank=True, null=True, unique=True)  # Unique Transaction Reference
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return f"{self.user_id} - {self.amount} ({self.status})"


        